//=============================================================================
// SkillMastery_ExtraCritical_Attach.js
// ----------------------------------------------------------------------------
// (C)2025 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2025/02/07 初版
// ----------------------------------------------------------------------------
// [Blog]   : https://ci-en.net/creator/14684
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc スキル使い込み機構 多段クリティカル機構連携プラグイン
 * @target MZ
 * @orderAfter ExtraCritical
 * @orderAfter SkillMastery
 * @author くろあめ
 * 
 * @param Skill Mastery Cri Prob Rate
 * @text スキル個別使い込み必殺率増幅レート
 * @desc スキル個別の使い込み値がこの値のとき、+10%の必殺率補正が付きます。
 * @default 1000
 * @type number
 * 
 * @param Skill Mastery Cri Amplify Rate
 * @text スキル個別使い込み必殺倍率増幅レート
 * @desc スキル個別の使い込み値がこの値のとき、+10%の必殺倍率補正が付きます。
 * @default 1000
 * @type number
 *
 * @param Lineage Mastery Cri Prob Rate
 * @text 系統使い込み必殺率増幅レート
 * @desc 系統使い込み値がこの値のとき、+10%の必殺率補正が付きます。
 * @default 2000
 * @type number
 * 
 * @param Lineage Mastery Cri Amplify Rate
 * @text 系統使い込み必殺倍率増幅レート
 * @desc 系統使い込み値がこの値のとき、+10%の必殺倍率補正が付きます。
 * @default 2000
 * @type number
 *
 *
 * @help
 * スキル個別使い込み値、系統使い込み値の現在値から
 * スキルの必殺率・必殺倍率に補正をかけます。
 * 
 * 必殺倍率の概念を導入する多段クリティカル機構と
 * スキル使い込み機構両方の導入が必要です。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */


(function() {

// 多段クリティカル機構のパラメータ呼び出し
const parametersExCri = PluginManager.parameters('ExtraCritical');
const crtMax          = Number(parametersExCri['Critical Max']);
const crtBaseRate     = Number(parametersExCri['Base Crt Rate']);
const crtPlusRate     = Number(parametersExCri['Plus Crt Rate']);
const crtLowerRate    = Number(parametersExCri['Lower Crt Rate']);
const ProbCrtLuckRate = Number(parametersExCri['Prob Crt LuckRate']);
const ProbCrtLuckMax  = Number(parametersExCri['Prob Crt LuckMax']);
const ProbCrtDamRate  = Number(parametersExCri['Prob Crt DamRate']);
const ProbCrtDamMax   = Number(parametersExCri['Prob Crt DamMax']);

// パラメータ用意
const parameters                     = PluginManager.parameters('SkillMastery_ExtraCritical_Attach');
const SkillMasteryCriProbRate        = Number(parameters['Skill Mastery Cri Prob Rate']);
const SkillMasteryCriAmplifyRate     = Number(parameters['Skill Mastery Cri Amplify Rate']);
const LineageMasteryCriProbRate      = Number(parameters['Lineage Mastery Cri Prob Rate']);
const LineageMasteryCriAmplifyRate   = Number(parameters['Lineage Mastery Cri Amplify Rate']);


// クリティカル率の取得(再定義)
/* 都合上、元処理は退避するだけで呼び出さない 処理ごと再定義 */
const _Game_Action_itemCri_SkillMastery = Game_Action.prototype.itemCri;
Game_Action.prototype.itemCri = function(target,cricnt) {
    var criProbPlus = 1.0;
    if(this.subject().luk >= target.luk){
       criProbPlus = 1.0 + (ProbCrtLuckRate * Math.min(this.subject().luk / target.luk, ProbCrtLuckMax));
    }
    var fullCriRate = this.subject().cri;
    fullCriRate += this.item().meta.CriProbBst ? this.item().meta.CriProbBst / 100.0 : 0;
    
    // ここまで多段クリティカル機構オリジナル
    // 以下、スキル使い込み機構の処理
    
    if(this.subject().isActor()){
        var skillPlus = 0;
        var lineagePlus = 0;
        var skillMagni = 0;
        var lineageMagni = 0;
        
        var lineageId = 0;
        if (this.item() && this.item().meta && this.item().meta.MasteryLineage) lineageId = Number(this.item().meta.MasteryLineage);

        if (DataManager.isSkill(this.item())) {
            skillMagni = this.subject().getSkillMasterySavevalues(this.item().id);
            skillPlus = 0.1 * skillMagni / SkillMasteryCriProbRate;
        }
        if (lineageId > 0) {
            lineageMagni = this.subject().getLineageMasterySavevalues(lineageId);
            lineagePlus = 0.1 * lineageMagni / LineageMasteryCriProbRate;
        }
        
        fullCriRate += skillPlus > 0 ? skillPlus : 0;
        fullCriRate += lineagePlus > 0 ? lineagePlus : 0;
        
    }
    
    return this.item().damage.critical ? (fullCriRate * criProbPlus / cricnt) * (1 - target.cev) : 0;
};



/* 攻撃者の全必殺倍率を合算して返す (再定義) */
/* 都合上、元処理は退避するだけで呼び出さない 処理ごと再定義 */
const _Game_Action_fullCriMagni_SkillMastery = Game_Action.prototype.fullCriMagni;
Game_Action.prototype.fullCriMagni = function(attacker,target,item,critical_lv ) {
    
    var fullMagni = 0;
    
    if (item && item.meta && item.meta.CriMagniBst) fullMagni += Number(item.meta.CriMagniBst);
    fullMagni += attacker.getCriMagniBst();
    
    // ここまで多段クリティカル機構オリジナル
    // 以下、スキル使い込み機構の処理
    
    if(this.subject().isActor()){
        var skillPlus = 0;
        var lineagePlus = 0;
        var skillMagni = 0;
        var lineageMagni = 0;
        
        var lineageId = 0;
        if (item && item.meta && item.meta.MasteryLineage) lineageId = Number(item.meta.MasteryLineage);

        if (DataManager.isSkill(item)) {
            skillMagni = this.subject().getSkillMasterySavevalues(item.id);
            skillPlus = Math.floor(10 * skillMagni / SkillMasteryCriAmplifyRate);
        }
        if (lineageId > 0) {
            lineageMagni = this.subject().getLineageMasterySavevalues(lineageId);
            lineagePlus = Math.floor(10 * lineageMagni / LineageMasteryCriAmplifyRate);
        }
        
        fullMagni += skillPlus > 0 ? skillPlus : 0;
        fullMagni += lineagePlus > 0 ? lineagePlus : 0;
        
    }
    
    // スキル使い込み機構の処理ここまで
    
    if(fullMagni > 0 && critical_lv > 1){
        fullMagni += Math.round(fullMagni * 0.25 * (critical_lv - 1));
    }
    
    fullMagni += target.getCriMagniReg();
    
    return fullMagni;
};


})();

